
typedef long long INT;
typedef long long TIMESTAMP;
typedef char* TEXT;

struct find_query {
  int column;
  int operation;
  int query_type;
  union {
    INT i;
    TEXT t;
    TIMESTAMP d;
  } query_data;
};

static const int find_query_operation_eq = 1;
static const int find_query_operation_lt = 2;
static const int find_query_operation_gt = 3;
static const int find_query_operation_le = 4;
static const int find_query_operation_ge = 5;
static const int find_query_operation_atDay = 6;
static const int find_query_operation_atMonth = 7;
static const int find_query_operation_atYear = 8;

static const int find_query_type_int = 1;
static const int find_query_type_text = 2;
static const int find_query_type_timestamp = 3;


struct column {
  TEXT name;
  TEXT readable_name;
  int column_type;
};


struct column_query {
  int column;
  int query_type;
  union {
    INT i;
    TEXT t;
    TIMESTAMP d;
  } query_data;
};


struct spravka1 {
  INT id;
  TEXT patient_name;
  TIMESTAMP date_interview;
  INT somatic_patology;
  TEXT protivopokazaniya;
  TEXT ekg;
  TEXT zakluchenie;
  TEXT vrach_terapevt;
};


static const int table_spravka1 = 1;


static const int spravka1_column_id = 1;
static const int spravka1_column_patient_name = 2;
static const int spravka1_column_date_interview = 3;
static const int spravka1_column_somatic_patology = 4;
static const int spravka1_column_protivopokazaniya = 5;
static const int spravka1_column_ekg = 6;
static const int spravka1_column_zakluchenie = 7;
static const int spravka1_column_vrach_terapevt = 8;

static const int spravka1_column_count = 8;


void oneesdocs_init();
void oneesdocs_terminate();

void oneesdocs_free(void* data);

void* oneesdocs_get(int table, INT* ids, int ids_count, int* out_count);
void* oneesdocs_find(int table, struct find_query* queries, int queries_count, int* out_count);
INT* oneesdocs_list(int* out_count);
struct column* oneesdocs_listFields(int table);
int oneesdocs_update(int table, INT id, struct column_query* queries, int queries_count);
int oneesdocs_insert(int table, struct column_query* queries, int queries_count);

